﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;

namespace PowerAmpDemoNS
{
    public partial class PowerAmpDemoProgram
    {
        // Test Procedures
        public int edgeTest()
        {
            // Configure variables for GSM Standard
            string testWaveform = edgeArb;
            string testName = "EDGE Test";
            vsag.setupParameters("EDGE");
            
            dataLog.tstName = "EDGE";

            dataLog.addResultsHeader(testName);
            //Start Test timer
            sw.Reset();
            sw.Start();

            // Configure for External Trigger on ARB Wrap signal
            vsag.configVsaTrigger("EXTERNAL");

            // Setup the VSG and VSA for waveform, band frequency and power level
            vsag.setupVsgVsa(testWaveform, cellFreqs[0], targetPout, targetGain);

            //"SWIT"  or "MOD" for ORFS from modulation or ORFS from switching 
            string orfsType = "MOD";
            int numAveragesORFS = 1;

            //if (testAcpr && testEvm)
            //    Lib.configEdgeCgsmMeas("MS", cellFreqs[0], targetPout, numAveragesORFS, orfsType);            
            //       // Configure the EVM measurement
            if (testEvm)
                vsag.configEdgeEvmMeas("MS", cellFreqs[0], targetPout);
            //else if (testAcpr)
            //    Lib.configEdgeOrfsMeas("MS", cellFreqs[0], targetPout, numAveragesORFS, orfsType);
    
            // Loop over Frequencies for Low Band
            for (int i = 0; i < cellFreqs.Length; i++)
            {
                dataLog.addResultsHeader("Frequency = " + (cellFreqs[i] / 1e6).ToString("0.0") +
                    " MHz, Output Power = " + targetPout.ToString("0.00") + " dBm");

                // Set VSG and VSA to test frequency
                vsag.setTestFreq(cellFreqs[i]);

                // Servo source until Pout is at correct value
                if (vsag.fftServo)
                    vsag.servoInputPowerFft(targetPout, poutMargin);
                else
                    vsag.servoInputPower(targetPout, poutMargin);

                if (testCurr)
                {
                    // Measure DC Current
                    dcSmu.measCurrent();
                }

                //if (testAcpr && testEvm)
                //{
                //    // Measure EVM and ORFS with X-App CGSM measurement
                //    // Unlock receiver from driver before starting, lock receiver and update setup when complete
                //    Lib.unlockM9391();
                //    Lib.measEdgeCgsm(cellFreqs[i]);
                //    Lib.lockM9391();
                //    Lib.M9391.RestoreDefaultProperties();
                //    Lib.setupVsa(cellFreqs[i], targetPout);
                //    // Configure for External Trigger on ARB Wrap signal
                //    Lib.configVsaTrigger(AgM9391AcquisitionTriggerModeEnum.AgM9391AcquisitionTriggerModeExternal);
                //}
                if (testAcpr)
                {
                    // Use IVI Driver to Measure ACPR
                    if (vsag.fftAcpr)
                        vsag.measGsmFftAcpr(1);
                    else
                        vsag.measGsmAcpr(1);
                }
                if (testEvm)
                {
                    // Measure ORFS or EVM with X-App
                    // Unlock receiver from driver before starting, lock receiver and update setup when complete
                    vsag.unlockVsa();
                    vsag.setXappFreq(cellFreqs[i]);
                    vsag.measEdgeEvm();
                    vsag.lockVsa();
                    
                    vsag.setupVsa(cellFreqs[i], targetPout);
                    // Configure for External Trigger on ARB Wrap signal
                    vsag.configVsaTrigger("EXTERNAL");
                }

                if (testHarms)
                {
                    vsag.measPwrHarms(true, true);
                }

                // Tests complete, setup for next test
                dataLog.nextTest();
            }

            // Put it back to immediate trigger
            vsag.configVsaTrigger("IMMEDIATE");

            // Update results and data log for end of test
            dataLog.addResultsFooter(testName, sw.ElapsedMilliseconds);
            return 0;
        }
    }
}
